/*
 * ConvertDA.cxx
 *
 * main file for ConvertDA
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */

#include <PalmOS.h>
#include "ConvertDA.h"
#include "ConvertDA_Rsc.h"
#include "MainForm.hxx"

inline void* GetObjectPtr( int objectID ) {
	FormType* pForm = ::FrmGetActiveForm( );
	UInt16    index = ::FrmGetObjectIndex( pForm, objectID );
	void*     ptr   = ::FrmGetObjectPtr( pForm, index );
	return ptr;
};

// preference
typedef struct _prefs {
	PointType lastTopLeft;
} PrefData;



// Internal Function prototype ===========================================
//static Err GetCurAppName( char* name );
static FieldType* GetParentField( );
static void InitPrefs( PrefData* pPref );
static void LoadPrefs( PrefData* pPref );
static void SavePrefs( PrefData* pPref );

//========================================================================
extern "C" {
void ConvertDA( ) {

	PrefData pref;

	// etH[̃tB[h擾B
	FieldType* pField = GetParentField( );
#ifndef DEBUG
	if( !pField ) {
		::FrmAlert( NO_ACTIVE_FIELD_ALERT );
		return;
	} else {
		UInt16 start, end;
		::FldGetSelection( pField, &start, &end );
		if( start == end ) {
			::FrmAlert( NO_SELECTION_ALERT );
			return;
		}
	}
#endif // NO_USE_PARENTFIELD


	// ȑONꂽƂ Preference [h
	LoadPrefs( &pref );

	MainForm theForm( pref.lastTopLeft, pField );
	theForm.DoModal( );

	// AvP[V̏I
	theForm.GetLastPosition( pref.lastTopLeft );
	SavePrefs( &pref );

}
} // extern "C"


// ẽAvP[V擾 ...  DA ł͖gp
//static Err GetCurAppName( char* name ) {
//	UInt16 cardNo;
//	LocalID dbID;
//	Err error = ::SysCurAppDatabase( &cardNo, &dbID );
//	if( !error )
//		error = DmDatabaseInfo( cardNo, dbID, name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
//	return error;
//}

// etH[̃tB[h擾B
static FieldType* GetParentField( ) {
	FormType* pParentForm = ::FrmGetActiveForm( );
	FieldType* pParentField = NULL;
	if( !!pParentForm ) {
		UInt16 focusIndex = ::FrmGetFocus( pParentForm );
		if( focusIndex != noFocus ) {
			switch( ::FrmGetObjectType( pParentForm, focusIndex ) ) {
			case frmFieldObj:
				pParentField = (FieldType*)::FrmGetObjectPtr( pParentForm, focusIndex );
				break;
			case frmTableObj: {
				TableType* pParentTable = (TableType*)::FrmGetObjectPtr( pParentForm, focusIndex );
				pParentField = (FieldType*)TblGetCurrentField( pParentTable );
				break;
			}
			default:
				pParentField = NULL;
				break;
			}
		}
	}
	return pParentField;
}

// vt@X
static void InitPrefs( PrefData* pPref ) {
	::MemSet( pPref, sizeof(PrefData), 0L );
	pPref->lastTopLeft.x = DefaultFrameXPos;
	pPref->lastTopLeft.y = DefaultFrameYPos;
}

// vt@Xǂݍ
static void LoadPrefs( PrefData* pPref ) {

	UInt32 romVersion = 0;
	::FtrGet( sysFtrCreator, sysFtrNumROMVersion, &romVersion );

	if( romVersion >= 0x02003000 ) {
		Int16	version = 0;
		UInt16	prefSize = 0;
		version = PrefGetAppPreferences( CREATORID, PREFERENCEID, NULL, &prefSize, true );
		if( version != noPreferenceFound && prefSize == sizeof(PrefData) )
			version = PrefGetAppPreferences( CREATORID, PREFERENCEID, pPref, &prefSize, true );
		else
			InitPrefs( pPref );
	} else {
		if( ::PrefGetAppPreferencesV10( CREATORID, PREFERENCEVERSION,
										pPref, sizeof(PrefData) ) == false )
			InitPrefs( pPref );
	}

}


// vt@Xۑ
static void SavePrefs( PrefData* pPref ) {
	UInt32 romVersion = 0;
	::FtrGet( sysFtrCreator, sysFtrNumROMVersion, &romVersion );

	if( romVersion >= 0x02003000 )
		::PrefSetAppPreferences( CREATORID, PREFERENCEID,
								 PREFERENCEVERSION, pPref, sizeof(PrefData), true );
	else
		::PrefSetAppPreferencesV10( CREATORID, PREFERENCEVERSION, pPref, sizeof(PrefData) );

}

