
#ifndef __DRAGGABLEMODALFORM_HXX__
#define __DRAGGABLEMODALFORM_HXX__

#include "ModalForm.hxx"


class DraggableModalForm : public ModalForm {

public:	// draggable support
	typedef bool (*DraggingCheckFunc)( const RectangleType&, Coord, Coord );

public:
	DraggableModalForm( UInt16 formID, const PointType& pos, DraggingCheckFunc dragFunc );
//	~DraggableModalForm( );

protected:
	BEGIN_PRE_EVENT_MAP(ModalForm)
		EVENT_MAP_ENTRY(frmOpenEvent, OnOpen)
	END_PRE_EVENT_MAP()

	BEGIN_EVENT_MAP(ModalForm)
		EVENT_MAP_ENTRY(penDownEvent, OnPenDown)
		EVENT_MAP_ENTRY(penMoveEvent, OnPenMove)
		EVENT_MAP_ENTRY(penUpEvent,   OnPenUp)
	END_EVENT_MAP()

	BEGIN_POST_EVENT_MAP(ModalForm)
	END_POST_EVENT_MAP()

private:	// event handler
	bool OnOpen( EventType* pEvent );
	bool OnPenDown( EventType* pEvent );
	bool OnPenMove( EventType* pEvent );
	bool OnPenUp( EventType* pEvent );

private:	// draggable support
	static bool IsTitleBarInside( const RectangleType& pRect, Coord x, Coord y );
	void ExorFrame( const RectangleType& rect );
	void RecalcFormLayout( EventType* pEvent, RectangleType& rect );

private:	// draggable support
	DraggingCheckFunc	m_dragFunc;
	bool				m_bDragging;
	PointType			m_position;

public:
	inline void GetLastPosition( PointType& pos ) { pos = m_position; };

};

#endif // __DRAGGABLEMODALFORM_HXX__
