
#include <PalmOS.h>
#include "ConvertDA.h"
#include "ConvertDA_Rsc.h"
#include "MainForm.hxx"
#include "Resource.hxx"
#include "StringConverter.hxx"

MainForm::MainForm( const PointType& pos, FieldType* pField ) : DraggableModalForm( MAINFORM, pos, DraggingCheck ),
																m_pField( pField ),
																m_pUndoInfo( NULL ) {
}

//MainForm::~MainForm( ) {
//}

UInt16 MainForm::DoModal( ) {

	FormType* pParentForm = LoadForm( );

	EventType	event;
	UInt16		error;

	m_bLoopContinue = true;
	do {
		::EvtGetEvent( &event, evtWaitForever );
		if( PreSystemEventHook( &event ) )
			continue;
		if( ::SysHandleEvent( &event ) )
			continue;
		if( ::MenuHandleEvent( NULL, &event, &error ) )
			continue;
		if( PreHandleEvent( &event ) )
			continue;
		bool bHandled = HandleEvent( &event );
		bHandled |= PostHandleEvent( &event );
		if( !bHandled )
			::FrmHandleEvent( ::FrmGetActiveForm( ), &event );
	} while( m_bLoopContinue );

	UnloadForm( pParentForm );

	return m_returnCode;

}

bool MainForm::PreSystemEventHook( EventType* pEvent ) {
	return false;
}

bool MainForm::OnOpen( EventType* pEvent ) {
	return false;	// need false...
}

bool MainForm::OnClose( EventType* pEvent ) {
	while( !!m_pUndoInfo ) {
		UndoInfo* p = m_pUndoInfo;
		m_pUndoInfo = m_pUndoInfo->pNext;
		::MemPtrFree( p->pData );
		::MemPtrFree( p );
	}
	return false;	// need false...
}

bool MainForm::OnKeyDown( EventType* pEvent ) {
	if( TxtCharIsHardKey( pEvent->data.keyDown.modifiers, pEvent->data.keyDown.chr ) ) {
		// HotSync! button pressed ?
		::EvtAddEventToQueue( pEvent );
		CloseForm( 0 );
		return true;
	}
	return false;
}

bool MainForm::OnButtonPressed( EventType* pEvent ) {

	UInt16 fromRes = 0;
	UInt16 destRes = 0;
	switch( pEvent->data.ctlSelect.controlID ) {
	case KATAKANA_BUTTON:		fromRes = TSTR_HIRAGANA;	destRes = TSTR_KATAKANA;	break;
	case HIRAGANA_BUTTON:		fromRes = TSTR_KATAKANA;	destRes = TSTR_HIRAGANA;	break;
	case SMALLCHAR_BUTTON:		fromRes = TSTR_CAPITALCHAR;	destRes = TSTR_SMALLCHAR;	break;
	case CAPITALCHAR_BUTTON:	fromRes = TSTR_SMALLCHAR;	destRes = TSTR_CAPITALCHAR;	break;
	case SINGLECHAR_BUTTON:		fromRes = TSTR_DOUBLECHAR;	destRes = TSTR_SINGLECHAR;	break;
	case DOUBLECHAR_BUTTON:		fromRes = TSTR_SINGLECHAR;	destRes = TSTR_DOUBLECHAR;	break;
	}
	typedef Resource<'tSTR', const char*> StringResource;
	if( !!fromRes && !!destRes ) {
		char* pOrg = NULL;
#ifndef DEBUG
		EraseForm( );
		pOrg = StringConverter::Convert( m_pField, StringResource( fromRes ), StringResource( destRes ) );
		DrawForm( );
#endif // DEBUG
		if( !!pOrg ) {
			UndoInfo* p = static_cast<UndoInfo*>( ::MemPtrNew( sizeof(UndoInfo) ) );
			p->pData = pOrg;
			p->pNext = m_pUndoInfo;
			m_pUndoInfo = p;
		}
	}

	//CloseForm( pEvent->data.ctlSelect.controlID );
	return true;

}

bool MainForm::OnCloseButton( EventType* pEvent ) {
	CloseForm( 0 );
	return true;
}

bool MainForm::OnUndo( EventType* pEvent ) {
	if( !m_pUndoInfo )
		::FrmAlert( NO_MORE_UNDO_ALERT );
	else {
		UndoInfo* p = m_pUndoInfo;
#ifndef DEBUG
		EraseForm( );
		StringConverter::Undo( m_pField, p->pData );
		DrawForm( );
#endif // DEBUG
		m_pUndoInfo = p->pNext;
		::MemPtrFree( p->pData );
		::MemPtrFree( p );
	}
	return true;
}

bool MainForm::DraggingCheck( const RectangleType& rect, Coord x, Coord y ) {
//	return ( 0 <= x && x <= rect.extent.x && 0 <= y && y <= 12 );				// ^Cgo[ŃhbOiwvACRȂj
	return ( 0 <= x && x <= rect.extent.x-15 && 0 <= y && y <= 12 );			// ^Cgo[ŃhbOiwvACRj
//	return ( 0 <= x && x <= rect.extent.x && 0 <= y && y <= rect.extent.y );	// tH[ŜŃhbO
}

