
#ifndef __MODALFORM_HXX__
#define __MODALFORM_HXX__

#include "MapMacro.hxx"

class ModalForm {
public:
	ModalForm( UInt16 formID );
//	~ModalForm( );

protected:
	inline FormType*	GetFormPtr( ) { return m_pForm; };
	inline UInt16		GetFormID( ) { return m_formID; };
	inline void			DrawForm( ) { ::FrmDrawForm( m_pForm ); };
	inline void			EraseForm( ) { ::FrmEraseForm( m_pForm ); };

protected:
	FormType*	LoadForm( );
	void		UnloadForm( FormType* pParentForm );
	void		GetWindowBounds( RectangleType& rect ) const;
	void		SetWindowBounds( const RectangleType& rect );

protected:
	void CloseForm( UInt16 retCode );

	BEGIN_ROOT_PRE_EVENT_MAP()
	END_ROOT_PRE_EVENT_MAP()

	BEGIN_ROOT_EVENT_MAP()
		EVENT_MAP_ENTRY(penDownEvent, OnPenDown)
		EVENT_MAP_ENTRY(appStopEvent, OnAppStop)
		EVENT_MAP_ENTRY(frmCloseEvent, OnClose)
	END_ROOT_EVENT_MAP()

	BEGIN_ROOT_POST_EVENT_MAP()
	END_ROOT_POST_EVENT_MAP()

private:	// event handler
	bool OnPenDown( EventType* pEvent );
	bool OnAppStop( EventType* pEvent );
	bool OnClose( EventType* pEvent );

private:
	bool IsOutside( const RectangleType& rect, Coord x, Coord y );

private:
	UInt16		m_formID;
	FormType*	m_pForm;

protected:
	UInt16		m_returnCode;
	bool		m_bLoopContinue;

};

#endif // __MODALFORM_HXX__
