//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// t@C           $Workfile:: Resource.hxx                                 $
// o[Wԍ       $Revision:: 1                                            $
// ŏIXV[U[     $Author:: Kagelow                                      $
// ŏI`FbNC     $Date:: 07/01/17 0:16                                $
// ŏIύX          $Modtime:: 07/01/16 23:39                               $
//                   $History:: Resource.hxx                                 $
// 
// *****************  Version 1  *****************
// User: Kagelow      Date: 07/01/17   Time: 0:16
// Created in $/Projects/DAForms
// VKo^
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


#ifndef __RESOURCE_HXX__
#define __RESOURCE_HXX__


template<DmResType resType, typename T>
class Resource {
public:
	typedef T ResourceType;
//	typedef typename T ResourceType;

public:
	Resource( UInt16 resID ) : m_handle( MemHandle( ) ),
							   m_pResource( ResourceType( ) ) {
		m_handle = ::DmGetResource( resType, resID );
		if( !!m_handle )
			m_pResource = reinterpret_cast<ResourceType>( ::MemHandleLock( m_handle ) );
//			m_pResource = static_cast<ResourceType>( ::MemHandleLock( m_handle ) );
	};

	~Resource( ) {
		::MemHandleUnlock( m_handle );
		::DmReleaseResource( m_handle );
	};

private:
	Resource( const Resource& rhs );
	Resource& operator=( const Resource& rhs );

private:
	void* operator new( UInt32 n ) { return ::MemPtrNew( n ); };
	void operator delete( void* p ) { ::MemPtrFree( p ); };

public:
	inline operator ResourceType( ) const {
		return m_pResource;
	};

private:
	MemHandle		m_handle;
	ResourceType	m_pResource;

};


#endif // __RESOURCE_HXX__


