//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// t@C           $Workfile::                                              $
// o[Wԍ       $Revision::                                              $
// ŏIXV[U[     $Author::                                              $
// ŏI`FbNC     $Date::                                              $
// ŏIύX          $Modtime::                                              $
//                   $History::                                              $
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

#include <PalmOS.h>
#include "StringUtility.hxx"
#include "StringConverter.hxx"

char* StringConverter::Convert( FieldType* pField, const char* pFrom, const char* pDest ) {

	UInt16 pos1 = 0;
	UInt16 pos2 = 0;
	::FldGetSelection( pField, &pos1, &pos2 );

	const char* pOrg = ::FldGetTextPtr( pField ) + pos1;
	UInt16 orgLen = pos2 - pos1;
	UInt16 newLen = 0;

	char* pBuf = static_cast<char*>( ::MemPtrNew( orgLen * 2 + 1 ) );
	char* pRet = NULL;
	if( ConvertString( pOrg, orgLen, pBuf, &newLen, pFrom, pDest ) == true ) {
		pRet = static_cast<char*>( ::MemPtrNew( orgLen + 1 ) );
		::StrNCopy( pRet, pOrg, orgLen );
		pRet[orgLen] = '\0';
		::FldDelete( pField, pos1, pos2 );
		::FldSetInsertionPoint( pField, pos1 );
		::FldInsert( pField, pBuf, newLen );
		::FldSetSelection( pField, pos1, pos1 + newLen );
	}
	::MemPtrFree( pBuf );
	return pRet;

}

void StringConverter::Undo( FieldType* pField, const char* p ) {

	UInt16 pos1 = 0;
	UInt16 pos2 = 0;
	::FldGetSelection( pField, &pos1, &pos2 );

	UInt16 len = ::StrLen( p );

	::FldDelete( pField, pos1, pos2 );
	::FldSetInsertionPoint( pField, pos1 );
	::FldInsert( pField, p, len );
	::FldSetSelection( pField, pos1, pos1 + len );

}

bool StringConverter::ConvertString( const char* pSource, UInt16 srcLen,
									 char* pBuf, UInt16* pNewLen,
									 const char* pFrom, const char* pDest ) {

	const char* pSourceEnd = pSource + srcLen;
	char* pB = pBuf;
	bool ret = false;
	while( pSource < pSourceEnd ) {
		const char* pNext = GetConvertUnit( pSource );
		const char* p = FindSubString( pSource, pNext, pFrom );
		if( !p ) {
			while( pSource < pNext )
				*pB++ = *pSource++;
		} else {
			ret = true;
			p = pDest + ( p - pFrom );
			switch( pNext - pSource ) {
			case 1:
				*pB++ = *p;
				if( StringUtility::IsLeadByte( *p ) )
					*pB++ = *(p+1);
				break;
			case 2:
				*pB++ = *p++;
				if( *p != ' ' )	// K Ȃǂ̏ꍇ̑Ή
					*pB++ = *p;
				break;
			}
			pSource = pNext;
		}
	}
	if( !!pNewLen )
		*pNewLen = pB - pBuf;
	return ret;
}

const char* StringConverter::GetConvertUnit( const char* p ) {
	const char* pRet = StringUtility::Increment( p );
	if( pRet - p == 2 )
		return pRet;
	if( *pRet == '' || *pRet == '' ) {
		for( const char* r = ""; !!*r; ++r )
			if( *p == *r ) {
				++pRet;
				break;
			}
	}
	return pRet;
}

const char* StringConverter::FindSubString( const char* pSource, const char* pEnd, const char* pTarget ) {
	while( !!*pTarget ) {
		if( ::MemCmp( pTarget, pSource, pEnd - pSource ) == 0 )
			return pTarget;
		pTarget = StringUtility::Increment( pTarget );
	}
	return NULL;
}
