//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// t@C           $Workfile::                                              $
// o[Wԍ       $Revision::                                              $
// ŏIXV[U[     $Author::                                              $
// ŏI`FbNC     $Date::                                              $
// ŏIύX          $Modtime::                                              $
//                   $History::                                              $
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

#include "StringUtility.hxx"

bool StringUtility::IsLeadByte( unsigned char c ) {
	return (0x81 <= c && c <= 0x9F) || (0xE0 <= c && c <= 0xFC);
}

/*
bool StringUtility::IsTrailByte( unsigned char c ) {
	return (0x40 <= c && c <= 0x7E) || (0x80 <= c && c <= 0xEC);
}
*/

const char* StringUtility::Increment( const char* p ) {
	const unsigned char* q = reinterpret_cast<const unsigned char*>( p );
	if( (0x80 < *q && *q < 0xA0) || (0xDF < *q && *q < 0xFE) )
		return p + 2;
	else {
		switch( *q ) {
		case 0x0A:
			return p + 1;
		case 0x0D:
			return ( *(q+1) == 0x0A ? p+2 : p+1 );
		default:
			return p + 1;
		}
	}
}

/*
const char* StringUtility::GetEndOfLine( const char* p ) {
	while( !!*p && *p != 0x0A && *p != 0x0D )
		p = StringUtility::Increment( p );
	return p;
}
*/

/*
const char* StringUtility::GetNextLine( const char* p ) {
	p = GetEndOfLine( p );
	if( !*p )
		return 0;
	return Increment( p );
}
*/
