#ifndef __MAPMACRO_HXX__
#define __MAPMACRO_HXX__


// Root pre-event map macros

#define BEGIN_ROOT_PRE_EVENT_MAP() \
bool PreHandleEvent( EventType* pEvent ) { \
	bool bHandled = false;

#define END_ROOT_PRE_EVENT_MAP() \
	return bHandled; \
}

// Root event map macros

#define BEGIN_ROOT_EVENT_MAP() \
bool HandleEvent( EventType* pEvent ) { \
	bool bHandled = false;

#define END_ROOT_EVENT_MAP() \
	return bHandled; \
}

// Root post-event map macros

#define BEGIN_ROOT_POST_EVENT_MAP() \
bool PostHandleEvent( EventType* pEvent ) { \
	bool bHandled = false;

#define END_ROOT_POST_EVENT_MAP() \
	return bHandled; \
}

// Pre-event map macros

#define BEGIN_PRE_EVENT_MAP(BaseFormClass) \
bool PreHandleEvent( EventType* pEvent ) { \
	typedef BaseFormClass BaseFormClassT; \
	bool bHandled = false;

#define END_PRE_EVENT_MAP() \
	if( !bHandled ) \
		bHandled = BaseFormClassT::PreHandleEvent( pEvent ); \
	return bHandled; \
}

// Event map macros

#define BEGIN_EVENT_MAP(BaseFormClass) \
bool HandleEvent( EventType* pEvent ) { \
	typedef BaseFormClass BaseFormClassT; \
	bool bHandled = false;

#define END_EVENT_MAP() \
	if( !bHandled ) \
		bHandled = BaseFormClassT::HandleEvent( pEvent ); \
	return bHandled; \
}

// Post-event map macros

#define BEGIN_POST_EVENT_MAP(BaseFormClass) \
bool PostHandleEvent( EventType* pEvent ) { \
	typedef BaseFormClass BaseFormClassT; \
	bool bHandled = false;

#define END_POST_EVENT_MAP() \
	if( !bHandled ) \
		bHandled = BaseFormClassT::PostHandleEvent( pEvent ); \
	return bHandled; \
}

// Basic event map entries

#define EVENT_MAP_ENTRY(EventNo, Action) \
	if( !bHandled && pEvent->eType == (EventNo) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_ENTRY_EX(EventNo, Action, Type) \
	if( !bHandled && pEvent->eType == (EventNo) ) { \
		bHandled = Action( (Type*)pEvent ); \
	}

#define EVENT_MAP_COMMAND_ENTRY(ControlID, Action) \
	if( !bHandled && pEvent->eType == ctlSelectEvent && pEvent->data.ctlSelect.controlID == (ControlID) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_COMMAND_REPEAT_ENTRY(ControlID, Action) \
	if( !bHandled && pEvent->eType == ctlRepeatEvent && pEvent->data.ctlRepeat.controlID == (ControlID) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_MENU_ENTRY(MenuID, Action) \
	if( !bHandled && pEvent->eType == menuEvent && pEvent->data.menu.itemID == (MenuID) ) { \
		MenuEraseStatus( MenuGetActiveMenu( ) ); \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_LIST_SELECT_ENTRY(ListID, Action) \
	if( !bHandled && pEvent->eType == lstSelectEvent && pEvent->data.lstSelect.listID == (ListID) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_POPUP_SELECT_ENTRY(PopupID, Action) \
	if( !bHandled && pEvent->eType == popSelectEvent && pEvent->data.popSelect.controlID == (PopupID) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_TABLE_SELECT_ENTRY(TableID, Action) \
	if( !bHandled && pEvent->eType == tblSelectEvent && pEvent->data.tblSelect.tableID == (TableID) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_KEY_DOWN_ENTRY(Chr, CommandModifier, Action) \
	if( !bHandled && pEvent->eType == keyDownEvent && pEvent->data.keyDown.chr == (Chr) && \
				( !(CommandModifier) || (pEvent->data.keyDown.modifiers & commandKeyMask) ) ) { \
		bHandled = Action( pEvent ); \
	}

#define EVENT_MAP_COMPONENT_ENTRY(ComponentEventID, ComponentID, Action) \
	if( !bHandled && pEvent->eType == componentEvent && \
			((ComponentEventType*)pEvent)->componentEventType == (ComponentEventID) && \
			((ComponentEventType*)pEvent)->componentID == (ComponentID) ) { \
		bHandled = Action( (ComponentEventType*)pEvent ); \
	}

// Additional event map entries for event filtering

#define PRE_EVENT_MAP_FILTER_ENTRY(Filter) \
	if( !bHandled ) \
		bHandled = (Filter).PreHandleEvent( pEvent );

#define EVENT_MAP_FILTER_ENTRY(Filter) \
	if( !bHandled ) \
		bHandled = (Filter).HandleEvent( pEvent );

#define POST_EVENT_MAP_FILTER_ENTRY(Filter) \
	if( !bHandled ) \
		bHandled = (Filter).PostHandleEvent( pEvent );

#define PRE_BYPASS_EVENT_MAP(Ancestor) \
	if( !bHandled ) \
		bHandled = Ancestor::PreHandleEvent( pEvent );

#define BYPASS_EVENT_MAP(Ancestor) \
	if( !bHandled ) \
		bHandled = Ancestor::HandleEvent( pEvent );

#define POST_BYPASS_EVENT_MAP(Ancestor) \
	if( !bHandled ) \
		bHandled = Ancestor::PostHandleEvent( pEvent );

#endif // __MAPMACRO_HXX__
