
#include <PalmOS.h>
#include "FortuneDAPP.h"
#include "FortuneDAPP_Rsc.h"
#include "MainForm.hxx"

MainForm::MainForm( const PointType& pos ) : DraggableModalForm( IdDAForm, pos, DraggingCheck ) {
}

//MainForm::~MainForm( ) {
//}

UInt16 MainForm::DoModal( ) {

	FormType* pParentForm = LoadForm( );

	EventType	event;
	UInt16		error;

	m_bLoopContinue = true;
	do {
		::EvtGetEvent( &event, evtWaitForever );
		if( PreSystemEventHook( &event ) )
			continue;
		if( ::SysHandleEvent( &event ) )
			continue;
		if( ::MenuHandleEvent( NULL, &event, &error ) )
			continue;
		if( PreHandleEvent( &event ) )
			continue;
		bool bHandled = HandleEvent( &event );
		bHandled |= PostHandleEvent( &event );
		if( !bHandled )
			::FrmHandleEvent( ::FrmGetActiveForm( ), &event );
	} while( m_bLoopContinue );

	UnloadForm( pParentForm );

	return m_returnCode;

}

bool MainForm::PreSystemEventHook( EventType* pEvent ) {
	return false;
}

bool MainForm::OnOpen( EventType* pEvent ) {
	InitFortune( );    // _̏
	FieldType* pField = (FieldType*)GetObjectPtr( IdFortuneField );
	ShowFortune( pField );    // _̕\
	return false;	// need false...
}

bool MainForm::OnClose( EventType* pEvent ) {
	FieldType* pField = (FieldType*)::GetObjectPtr( IdFortuneField );
	::FldSetTextHandle( pField, NULL );
	if( m_fortuneHandle != NULL )
		::MemHandleFree( m_fortuneHandle );
	m_fortuneHandle = NULL;
	return false;	// need false...
}

bool MainForm::OnKeyDown( EventType* pEvent ) {
	if( TxtCharIsHardKey( pEvent->data.keyDown.modifiers, pEvent->data.keyDown.chr ) ) {
		// HotSync! {^ꂽ?
		::EvtAddEventToQueue( pEvent );
		CloseForm( 0 );
		return true;
	}
	return false;
}

void MainForm::InitFortune( ) {
#if defined(JAPANESE_FORTUNE)
	StrCopy( m_fortune[0], "[[A͂!" );
	StrCopy( m_fortune[1], "Ƃ邩..." );
	StrCopy( m_fortune[2], "bL[J[͗ΐF!" );
	StrCopy( m_fortune[3], "bL[J[͏M̐!" );
	StrCopy( m_fortune[4], "CɍU߂悤!" );
	StrCopy( m_fortune[5], "iɒ!" );
	StrCopy( m_fortune[6], "ȂɈȂ!" );
	StrCopy( m_fortune[7], "񂲂!!" );
#else
	StrCopy( m_fortune[0], "Good day!" );
	StrCopy( m_fortune[1], "Bad day!" );
	StrCopy( m_fortune[2], "Lucky color is green!" );
	StrCopy( m_fortune[3], "Lucky color is passion red!" );
	StrCopy( m_fortune[4], "Be aggressive!" );
	StrCopy( m_fortune[5], "Be careful of your boss!" );
	StrCopy( m_fortune[6], "Not too bad" );
	StrCopy( m_fortune[7], "Veeeryyy well!" );
#endif
}

void MainForm::ShowFortune( FieldType* pField ) {
	m_fortuneHandle = ::MemHandleNew( MaxFortuneChars );
	char* p = (char*)::MemHandleLock( m_fortuneHandle );
	::StrCopy( p, m_fortune[::SysRandom( TimGetTicks( ) ) % FORTUNECNT] );
	::MemHandleUnlock( m_fortuneHandle );
	::FldSetTextHandle( pField, (MemHandle)m_fortuneHandle );
	::FldDrawField( pField );
}

bool MainForm::DraggingCheck( const RectangleType& rect, Coord x, Coord y ) {
	return ( 0 <= x && x <= rect.extent.x && 0 <= y && y <= rect.extent.y );
}
