
#include <PalmOS.h>
#include "DraggableModalForm.hxx"

DraggableModalForm::DraggableModalForm( UInt16 formID,
										const PointType& pos,
										DraggingCheckFunc dragFunc ) : ModalForm( formID ),
																	   m_dragFunc( dragFunc ),
																	   m_bDragging( false ),
																	   m_position( pos ) {
	if( !m_dragFunc )
		m_dragFunc = IsTitleBarInside;
}

//DraggableModalForm::~DraggableModalForm( ) {
//}

bool DraggableModalForm::OnOpen( EventType* pEvent ) {
	// ŌɋNꂽʒu𕜌
	RectangleType rect;
	GetWindowBounds( rect );
	EraseForm( );
	rect.topLeft = m_position;
	SetWindowBounds( rect );
	DrawForm( );
	return false;
}

bool DraggableModalForm::OnPenDown( EventType* pEvent ) {

	bool bHandled = false;

	RectangleType rect;
	GetWindowBounds( rect );

	if( m_dragFunc( rect, pEvent->screenX, pEvent->screenY ) ) {
		// hbOJn
		m_position.x = rect.topLeft.x + pEvent->screenX;
		m_position.y = rect.topLeft.y + pEvent->screenY;
		m_bDragging = true;
		EraseForm( );

		// hbÓAg\
		ExorFrame( rect );
		bHandled = true;

	}

	return bHandled;

}

bool DraggableModalForm::OnPenMove( EventType* pEvent ) {

	if( !m_bDragging )
		return false;

	// SndPlaySystemSound( sndClick );			// for test...

	RectangleType rect;
	GetWindowBounds( rect );

	// Oɕ`悵g
	ExorFrame( rect );

	// VtH[ʒuvZ
	RecalcFormLayout( pEvent, rect );
	SetWindowBounds( rect );

	// Vg\
	ExorFrame( rect );

	return true;

}

bool DraggableModalForm::OnPenUp( EventType* pEvent ) {

	if( !m_bDragging )
		return false;

	RectangleType rect;
	GetWindowBounds( rect );

	// ȑO̘g
	ExorFrame( rect );

	// VtH[ʒuvZ
	RecalcFormLayout( pEvent, rect );
	SetWindowBounds( rect );

	// vt@XɁAŌ̈ʒuL^
	m_position = rect.topLeft;

	m_bDragging = false;
	DrawForm( );

	return true;

}

bool DraggableModalForm::IsTitleBarInside( const RectangleType& rect, Coord x, Coord y ) {
	return ( 0 <= x && x <= rect.extent.x-15 && 0 <= y && y <= 12 );
}

void DraggableModalForm::ExorFrame( const RectangleType& rect ) {
	RectangleType r = rect;
	r.topLeft.x += 2;
	r.topLeft.y += 2;
	r.extent.x  -= 4;
	r.extent.y  -= 4;
	::WinInvertRectangleFrame( boldRoundFrame, &r );
}

void DraggableModalForm::RecalcFormLayout( EventType* pEvent, RectangleType& rect ) {
	Coord	moveX = pEvent->screenX - m_position.x;
	Coord	moveY = pEvent->screenY - m_position.y;
	rect.topLeft.x += moveX;
	rect.topLeft.y += moveY;
	if( rect.topLeft.x < 0 )
		rect.topLeft.x = 0;
	if( rect.topLeft.x + rect.extent.x > 160 )
		rect.topLeft.x = 160 - rect.extent.x;
	if( rect.topLeft.y < 0 )
		rect.topLeft.y = 0;
	if( rect.topLeft.y + rect.extent.y > 160 )
		rect.topLeft.y = 160 - rect.extent.y;
	m_position.x = pEvent->screenX;
	m_position.y = pEvent->screenY;
}

