
#include <PalmOS.h>
#include "ModalForm.hxx"

ModalForm::ModalForm( UInt16 formID ) : m_formID( formID ) {
}

//ModalForm::~ModalForm( ) {
//}

FormType* ModalForm::LoadForm( ) {
	FormType* pParentForm = ::FrmGetActiveForm( );
	m_pForm = ::FrmInitForm( m_formID );
	::FrmSetActiveForm( m_pForm );
	::FrmDrawForm( m_pForm );

	EventType event;
	event.eType = frmOpenEvent;
	event.data.frmOpen.formID = m_formID;
	::EvtAddEventToQueue( &event );

	return pParentForm;
}

void ModalForm::UnloadForm( FormType* pParentForm ) {
	::FrmEraseForm( m_pForm );
	::FrmDeleteForm( m_pForm );
	m_pForm = NULL;
	::FrmSetActiveForm( pParentForm );
}

void ModalForm::GetWindowBounds( RectangleType& rect ) const {
	::WinGetBounds( ::FrmGetWindowHandle( m_pForm ), &rect );
}

void ModalForm::SetWindowBounds( const RectangleType& rect ) {
	::WinSetBounds( ::FrmGetWindowHandle( m_pForm ), &rect );
}


void ModalForm::CloseForm( UInt16 retCode ) {
	m_returnCode = retCode;
	EventType event;
	event.eType = frmCloseEvent;
	event.data.frmClose.formID = m_formID;
	::EvtAddEventToQueue( &event );
}

bool ModalForm::OnPenDown( EventType* pEvent ) {
	bool bHandled = false;
	RectangleType rect;
	GetWindowBounds( rect );
	if( IsOutside( rect, pEvent->screenX, pEvent->screenY ) ){
		CloseForm( 0 );    // tH[̊OŃ^bvꂽ -- I
		bHandled = true;
	}
	return bHandled;
}

bool ModalForm::OnAppStop( EventType* pEvent ) {
	// appStopEvent AƂ̃AvP[Vɑ
	::EvtAddEventToQueue( pEvent );
	CloseForm( 0 );
	return true;
}

bool ModalForm::OnClose( EventType* pEvent ) {
	m_bLoopContinue = false;
	return true;
}

bool ModalForm::IsOutside( const RectangleType& rect, Coord x, Coord y ) {
	return !( 0 <= x && x <= rect.extent.x && 0 <= y && y <= rect.extent.y );
}
