
#ifndef __MAINFORM_HXX__
#define __MAINFORM_HXX__

#include "DraggableModalForm.hxx"

class MainForm : public DraggableModalForm {
public:
	MainForm( const PointType& pos );
//	~MainForm( );

public:
	UInt16 DoModal( );

private:
	bool PreSystemEventHook( EventType* pEvent );

private:
	BEGIN_PRE_EVENT_MAP(DraggableModalForm)
	END_PRE_EVENT_MAP()

	BEGIN_EVENT_MAP(DraggableModalForm)
		EVENT_MAP_ENTRY(keyDownEvent, OnKeyDown)
		EVENT_MAP_ENTRY(frmOpenEvent, OnOpen)
		EVENT_MAP_ENTRY(frmCloseEvent, OnClose)
	END_EVENT_MAP()

	BEGIN_POST_EVENT_MAP(DraggableModalForm)
	END_POST_EVENT_MAP()

private:	// event handler
	bool OnOpen( EventType* pEvent );
	bool OnClose( EventType* pEvent );
	bool OnKeyDown( EventType* pEvent );

private:	// event handler
	void InitFortune( );
	void ShowFortune( FieldType* pField );

private:
	static bool DraggingCheck( const RectangleType& pRect, Coord x, Coord y );

private:
	MemHandle	m_fortuneHandle;
	char		m_fortune[FORTUNECNT][MaxFortuneChars];
};

#endif // __MAINFORM_HXX__
