/*
    This application is intended to be sample application of DA.

    This source code is quite depend on many contributor (advice and
    source code) of pilot-tech JP mailing list members. Very thanks!!

    This code is free, you can copy/distribute/modify it
    (include commercial purpose).

    Topics covered in this application && contributor are :
	* Basics for DA application (on gcc)
	    Yamasa-san, Hoshi-san
	* Draggable DA
	    Araki-san
	* Detection of duplicate invocation (of same DA)
	    Araki-san
	* Draw just 'frame' on dragging. (transparent window shows background)
	    It's just myself, Kawashima
	* Know which application (parent) invoke this DA
	    Endo-san
	* How to avoid HotSync! problem on DA (HotSync! does not start when
	  DA is active)
	    Imazeki-san, Takahashi-san, Senba-san
*/
/*
     DA ̃TvƂč쐬AvP[VłB
    ̃\[XR[h { pilot-tech ML ̃o[łA̕
    MdȃAhoCXE\[XR[h񋟂쐬ꂽ̂łB

    ̃\[X̓t[łBRs[/Ĕzz/C܂B(pp܂߂)

    ̃\[XŃJo[Ă DA ֘ÃgsbNXƂ̃IWi :
	* DA Ƃē삷邽߂̊{Iȍ\
	    RcAق
	* Draggable Ή
	    r؂
	* DA ̓dŇo
	    r؂
	* Drag Ɂugv\ăobNOh悤ɂ()
	    ꂾ͎A쓇...
	* DA ǂ̃AvP[V(e)Nꂽ̂m
	    
	* DA N HotSync! {^ꂽꍇ HosSync! JnȂ
	  @
	    ւAAg
    łB
*/

#include <Common.h>
#include <System/SysAll.h>
#include <System/SysEvtMgr.h>
#include <UI/UIAll.h>

#include "Defs.h"

#define	FortuneDACreatorID	'FtDA'
#define	FortuneDAPrefsID	0

#define	FortuneDAPrefsVersion	0x0000

#define	Fortunes		8

#define	JapaneseFortune		1


// preference
typedef struct _prefs {
    SWord lastX;
    SWord lastY;
} _prefs;
    

// global variable
typedef struct _global {
    _prefs		prefs;
    SWord		fromX;
    SWord		fromY;
    Boolean		moving;
    VoidHand	fortuneHandle;
    char		fortune[Fortunes][MaxFortuneChars];
} _global;


void DAMain( );

/* This code must be here. (first of code section)*/
/* ̃R[h͂ɂȂႾ߁B(R[ḧ̎n)*/
void start( )
{
    DAMain( );
}

/*========================================================================*/

/* Followings are real implementatiom */
/* ȉۂ̎ */

static void *GetObjectPtr( int objectID ) {
    FormPtr form;
    Int     index;
    void*	ptr;
    form  = FrmGetActiveForm( );
    index = FrmGetObjectIndex( form, objectID );
    ptr   = FrmGetObjectPtr( form, index );
    return ptr;
}


/* Initialize Preference */
/* Preference ̏ */
static void InitPrefs( _global *g ) {
    MemSet( &g->prefs, sizeof(_prefs), 0L );
    g->prefs.lastX = DefaultFrameXPos;
    g->prefs.lastY = DefaultFrameYPos;
}


/* Load Preference */
/* vt@Xǂݍ */
static void LoadPrefs( _global *g ) {
    Int version;
    Word prefSize;
    version = PrefGetAppPreferences( FortuneDACreatorID, FortuneDAPrefsID, &g->prefs, &prefSize, true );
    if( version == noPreferenceFound ) {
		InitPrefs( g );
    } else {
		switch( version ) {
		default:
			;
		}
    }
}

/* Save Preference */
/* vt@Xۑ */
static void SavePrefs( _global *g ) {
    PrefSetAppPreferences( FortuneDACreatorID, FortuneDAPrefsID,
						   FortuneDAPrefsVersion, &g->prefs, sizeof(g->prefs), true );
}

/* Initialize global variables */
/* O[oϐ */
static _global *InitGlobals( ) {
    _global *g;
    g = MemPtrNew( sizeof(_global) );
    return g;
}

static void InitFortune( _global *g ) {
#if defined(JapaneseFortune)
    StrCopy( g->fortune[0], "[[A͂!" );
    StrCopy( g->fortune[1], "Ƃ邩..." );
    StrCopy( g->fortune[2], "bL[J[͗ΐF!" );
    StrCopy( g->fortune[3], "bL[J[͏M̐!" );
    StrCopy( g->fortune[4], "CɍU߂悤!" );
    StrCopy( g->fortune[5], "iɒ!" );
    StrCopy( g->fortune[6], "ȂɈȂ!" );
    StrCopy( g->fortune[7], "񂲂!!" );
#else
    StrCopy( g->fortune[0], "Good day!" );
    StrCopy( g->fortune[1], "Bad day!" );
    StrCopy( g->fortune[2], "Lucky color is green!" );
    StrCopy( g->fortune[3], "Lucky color is passion red!" );
    StrCopy( g->fortune[4], "Be aggressive!" );
    StrCopy( g->fortune[5], "Be careful of your boss!" );
    StrCopy( g->fortune[6], "Not too bad" );
    StrCopy( g->fortune[7], "Veeeryyy well!" );
#endif
}

static void ShowFortune( FieldPtr field, _global *g ) {
    char* p;
    g->fortuneHandle = MemHandleNew( MaxFortuneChars );
    p = MemHandleLock( g->fortuneHandle );
    StrCopy( p, g->fortune[SysRandom( TimGetTicks( ) ) % Fortunes] );
    MemHandleUnlock( g->fortuneHandle );
    FldSetTextHandle( field, (Handle)g->fortuneHandle );
    FldDrawField( field );
}

/* Get Parent application name ... but not used in this DA */
/* ẽAvP[V擾 ...  DA ł͖gp */
Err GetCurAppName( CharPtr name ) {
    Err error;
    UInt cardNo;
    LocalID dbID;
    error = SysCurAppDatabase( &cardNo, &dbID );
    if( !error )
		error = DmDatabaseInfo( cardNo, dbID, name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
    return error;
}


/* Tapped inside of this DA's form ? */
/*  DA ̃tH[̓Ń^bvꂽ? */
static Boolean IsInside( RectanglePtr r, SWord x, SWord y ) {
  return ( 0 <= x && x <= r->extent.x && 0 <= y && y <= r->extent.y );
}


/* Tapped outside of this DA's form ? */
/*  DA ̃tH[̊OŃ^bvꂽ? */
static Boolean IsOutside( RectanglePtr r, SWord x, SWord y ) {
  return !IsInside( r, x, y );
}


/* Draw frame with EX-OR mode */
/* t[ EX-OR [hŕ` */
static void ExorFrame( Word topLeftX, Word topLeftY, _global *g ) {
    RectangleType r;
    r.topLeft.x = topLeftX + 2;
    r.topLeft.y = topLeftY + 2;
    r.extent.x  = FrameXSize  - 4;
    r.extent.y  = FrameYSize - 4;
    WinInvertRectangleFrame( boldRoundFrame, &r );
}

/* Event Handler */
/* Cxgnh[ */
static Boolean DAHandleEvent( EventPtr event, _global *g ) {

    Boolean	done = false;
    Boolean	handled = false;
    FormPtr	form;
    SWord	moveX
	SWord	moveY;
    Word	ch;

    switch( event->eType ) {
    case appStopEvent:
		/* appStopEvent AƂ̃AvP[Vɑ */
		EvtAddEventToQueue( event );
		done = true;
		handled = true;
		break;
    case keyDownEvent:
		ch = event->data.keyDown.chr;
		if( ChrIsHardKey( ch ) ) {
		    /* maybe 'HotSync!' button pressed ? */
		    /* HotSync! {^ꂽ? */
		    EvtAddEventToQueue( event );
		    done = true;
		    handled = true;
		}
		break;
    case penDownEvent:    /* ȉ́AhbKu@\̎ */
		form = FrmGetActiveForm( );
		if( IsInside( &form->window.windowBounds, event->screenX, event->screenY ) ) {
		    /* hbOJn */
		    g->fromX  = event->screenX;
		    g->fromY  = event->screenY;
		    g->moving = true;
		    FrmEraseForm( form );
		    /* hbÓAg\ */
		    ExorFrame( 0, 0, g );
		    handled = true;
		} else if( IsOutside( &form->window.windowBounds, event->screenX, event->screenY ) ) {
		    /* tH[̊OŃ^bvꂽ -- I */
		    done = true;
		    handled = true;
		}
		break;
    case penMoveEvent:
		if( g->moving ) {
		    form = FrmGetActiveForm( );
		    moveX = event->screenX - g->fromX;
		    moveY = event->screenY - g->fromY;
	
		    /* Oɕ`悵g */
		    ExorFrame( 0, 0, g );
	
		    /* VtH[ʒuvZ */
		    form->window.windowBounds.topLeft.x += moveX;
		    form->window.windowBounds.topLeft.y += moveY;
		    if( form->window.windowBounds.topLeft.x < FrameWidth )
				form->window.windowBounds.topLeft.x = FrameWidth;
		    if( form->window.windowBounds.topLeft.y < FrameWidth )
				form->window.windowBounds.topLeft.y = FrameWidth;
		    if( form->window.windowBounds.topLeft.x + form->window.windowBounds.extent.x + FrameWidth >= form->window.displayWidth )
				form->window.windowBounds.topLeft.x = form->window.displayWidth -  form->window.windowBounds.extent.x - FrameWidth;
		    if( form->window.windowBounds.topLeft.y + form->window.windowBounds.extent.y + FrameWidth >= form->window.displayHeight )
				form->window.windowBounds.topLeft.y = form->window.displayHeight - form->window.windowBounds.extent.y - FrameWidth;

		    /* Vg\ */
		    ExorFrame( 0, 0, g );
		    handled = true;
		}
		break;
    case penUpEvent:
		form = FrmGetActiveForm( );
		if( g->moving ) {
		    /* Erase last frame */
		    /* ȑO̘g */
		    ExorFrame( 0, 0, g );
		    /* Save last position into preference */
		    /* vt@XɁAŌ̈ʒuL^ */
		    g->prefs.lastX = form->window.windowBounds.topLeft.x;
		    g->prefs.lastY = form->window.windowBounds.topLeft.y;
		    g->moving = false;
		    FrmDrawForm( form );
		    handled = true;
		}
		break;
    default:
		break;
    }

    if( !handled )
		FrmHandleEvent( FrmGetActiveForm( ), event );

    return done;

}

/* Event Loop */
/* Cxg[v */
static void EventLoop( _global *g ) {

    EventType	event;
    Boolean		done = false;
    Word		error;

    do {
		EvtGetEvent( &event, evtWaitForever );
		if( SysHandleEvent( &event ) )
		    continue;
		if( MenuHandleEvent( NULL, &event, &error ) )
		    continue;
		done = DAHandleEvent( &event, g );
    } while ( !done );

}

/* main function body */
/* C֐{ */
void DAMain( ) {

    _global*	g;
    FormPtr		form;
    FieldPtr	field;
    DWord		feature = 0;

    /* ( Fortune DA ) DA ̓dNoB*/
    if( FtrGet( FortuneDACreatorID, 0, &feature ) == 0 )
		return;											/* ł Fortune DA NĂ -- dN */
	else
		FtrSet( FortuneDACreatorID, 0, feature );		/* dN邽߂ɃtB[`[o^ */


    /* O[oϐ̈̊蓖ĂƂ̏ */
    g = InitGlobals( );
    if( !g )
		return;			/* O[oϐ̈̊蓖ĂɎs */


    /* ȑONꂽƂ Preference [h */
    LoadPrefs( g );


    /* CtH[N */
    form  = FrmInitForm( IdDAForm );

    /* ŌɋNꂽʒu𕜌 */
    form->window.windowBounds.topLeft.x = g->prefs.lastX;
    form->window.windowBounds.topLeft.y = g->prefs.lastY;
    FrmSetActiveForm( form );
    FrmDrawForm( form );

    /* _̏ */
    InitFortune( g );

    /* _̕\ */
    field = GetObjectPtr( IdFortuneField );
    ShowFortune( field, g );

    /* Cxgnh[ɐn */
    EventLoop( g );

    /* finish up application */
    /* AvP[V̏I */
    field = GetObjectPtr( IdFortuneField );
    FldSetTextHandle( field, NULL );
    if( g->fortuneHandle != NULL )
		MemHandleFree( g->fortuneHandle );
    g->fortuneHandle = NULL;
    SavePrefs( g );
    FrmEraseForm( form );
    FrmDeleteForm( form );

    /* tB[`[ */
    if( FtrGet( FortuneDACreatorID, 0, &feature ) == 0 )
		FtrUnregister( FortuneDACreatorID, 0 );

    /* O[oϐ̈ */
    MemPtrFree( g );

}
