## Palm OS Generic 68K Makefile Engine
#
# Last edit: 11/10/04
#
# This makefile engine is capable of compiling straight 68K 
# applications for the Palm OS.
#
# This makefile engine assumes that the following variables are 
# set outside of this makefile by a referencing master makefile
# (see a master makefile generated by a Palm OS Developer 
# Suite wizard for detailed explanation of each variable):
#
#	SOURCES
#	RESOURCES
#	MULTIPLE_CODE_SECTIONS 
#	CREATOR_ID 
#	DB_TYPE 
#	DATABASE_RESET 
#	DATABASE_BACKUP 
#	DATABASE_HIDDEN 
#	DATABASE_PROTECT 
#	DATABASE_BUNDLE
#	DATABASE_VERSION 
#	DEBUG_OR_RELEASE 
#	OPTIMIZE_LEVEL 
#	WARNING_LEVEL  
#	ADDITIONAL_LINK_LIBRARIES 
#	LOCAL_INCLUDE_PATHS 
#	SYSTEM_INCLUDE_PATHS 
#	DEFINES 
#	ADDITIONAL_COMPILER_FLAGS 
#	ADDITIONAL_LINKER_FLAGS 
#	ADDITIONAL_AR_FLAGS
#	TEXTENCODING
#	LOCALE_CHECKING
#	STRICT_ENCODING
#	TARGET_PLATFORM
#
# Additionally, the user of this makefile engine may obtain the 
# dynamic values for:
#	PROJECT_TYPE
#	SDK_LOCATION
#	SDK_VERSION
#	TOOLS_DIR 
# by doing an optional include of a makefile segment that is 
# generated during the the Developer Suite standard make build.
# The makefile line to accomplish this is:
#	-include auto-generated.mk
# All master makefiles generated by the Developer Suite
# wizards include this line already to pick up and use these
# dynamic definitions.
#
# All variable values may be overridden by editing the make command
# for the project (Project->Properties->C/C++ Make Project->Make Builder,
# Build Command field).
#

###############################################################################
# Defaults

PRCFLAGS +=

ifeq ($(DEBUG_DEVICE_OUTPUT_DIR), )
	DEBUG_DEVICE_OUTPUT_DIR = Debug
endif

ifeq ($(RELEASE_DEVICE_OUTPUT_DIR), )
	RELEASE_DEVICE_OUTPUT_DIR = Release
endif

ifeq ($(DEBUG_SIMULATOR_OUTPUT_DIR), )
	DEBUG_SIMULATOR_OUTPUT_DIR = Debug
endif

ifeq ($(RELEASE_SIMULATOR_OUTPUT_DIR), )
	RELEASE_SIMULATOR_OUTPUT_DIR = Release
endif

# Locale (defaults to english)
ifeq ($(LOCALE), )
	LOCALE := jpJP
endif

# PRC and Database names
ifeq ($(PRC_NAME), )
	PRC_NAME = Start.prc
endif

ifeq ($(DATABASE_NAME), )
	DATABASE_NAME = StartApp
endif

ifeq ($(ESCAPED_ARTIFACT_NAME), )
	ESCAPED_ARTIFACT_NAME = Start
endif

ifeq ($(LIB_NAME), )
	LIB_NAME = Start.a
endif

ifeq ($(SDK_VERSION), )
	SDK_VERSION = sdk-5r4
endif

# set output directories
ifeq ($(DEBUG_OR_RELEASE), Debug)
	OBJ_DIR = $(DEBUG_DEVICE_OUTPUT_DIR)
else
	OBJ_DIR = $(RELEASE_DEVICE_OUTPUT_DIR)
endif

# set DataBase Type
ifeq ($(DEBUG_OR_RELEASE), Debug)
	DB_TYPE = appl
else
	DB_TYPE = DAcc
endif

TARGET	:= $(OBJ_DIR)/$(PRC_NAME)
LINKER_OUTPUT := $(OBJ_DIR)/$(ESCAPED_ARTIFACT_NAME)
STATIC_LIB_TARGET := $(OBJ_DIR)/$(LIB_NAME)

# sdk-# assumed...
TARGET_FORMAT=PalmOS4
SDKFLAG = $(subst sdk-,-palmos,$(SDK_VERSION))
CFLAGS += $(SDKFLAG)
DEPFLAGS = -MM -MG -P -w 


# Compiler settings... compiler + optimizations + debug
CC = m68k-palmos-gcc
AS = m68k-palmos-as
MS = m68k-palmos-multigen
SG = m68k-palmos-stubgen
OR = m68k-palmos-obj-res

CFLAGS += -D__PALMOS__=0x05000000

# Optimization settings
ifeq ($(OPTIMIZE_LEVEL), FULL)
	OPTIMIZER_FLAG	= -O3
else
ifeq ($(OPTIMIZE_LEVEL), SOME)
	OPTIMIZER_FLAG	= -O1
else
ifeq ($(OPTIMIZE_LEVEL), NONE)
	OPTIMIZER_FLAG	= -O0
else
# default to FULL
	OPTIMIZER_FLAG	= -O3
endif
endif
endif
	
# Debug settings (can override optimize settings)
ifeq ($(DEBUG_OR_RELEASE), Debug)
	DEBUG_FLAG += -g
	OPTIMIZER_FLAG = -O0
else
	OPTIMIZER_FLAG = -O2
endif	

CFLAGS += $(OPTIMIZER_FLAG) $(DEBUG_FLAG)

# Warning level
ifeq ($(WARNING_LEVEL), ALL)
	CFLAGS += -Wall 
else
ifeq ($(WARNING_LEVEL), NONE)
	CFLAGS += -w
endif
endif

# Warnings as errors
ifeq ($(WARNING_AS_ERROR), TRUE)
	CFLAGS += -Werror
endif

# Verbose output
ifeq ($(VERBOSE), TRUE)
	CFLAGS += -v
endif

# Linker settings (must come after setting DEBUG_FLAG)
LD = m68k-palmos-gcc
LDFLAGS += $(DEBUG_FLAG)

ifeq ($(PROJECT_TYPE), slib)
	LDFLAGS += -nostartfiles
endif

ifeq ($(DEBUG_OR_RELEASE), Release)
	LDFLAGS += -nostartfiles
endif

ifeq ($(DEBUG_OR_RELEASE), Debug)
	CODE_RSC = $(OBJ_DIR)/*.$(ARTIFACT_NAME).grc
else
	CODE_RSC = $(OBJ_DIR)/code03e8.grc
endif

# Resource flags (PalmRC)
RFLAGS +=

# Default text encoding is Latin
ifeq ($(PRC_TEXT_ENCODING), )
	PRC_TEXT_ENCODING = JAPANESE
endif

ifeq ($(PRC_TEXT_ENCODING), LATIN)
	RFLAGS += -target 4.0
else
ifeq ($(PRC_TEXT_ENCODING), JAPANESE)
	RFLAGS += -target 4.0J
else
ifeq ($(PRC_TEXT_ENCODING), SIMPLIFIED_CHINESE)
	RFLAGS += -target 4.0CS
endif
endif
endif

ifeq ($(PRC_NO_LOCALE_CHECK), TRUE)
	RFLAGS += -noLocaleCheck
endif

ifeq ($(PRC_STRICT_LOCALE), TRUE)
	RFLAGS += -strictLocale
endif

ifeq ($(PRC_STRICT_ENCODING), TRUE)
	RFLAGS += -strictTextEncoding
endif

ifdef PRC_OVERLAY_FILTER
	RFLAGS += -overlayFilter $(PRC_OVERLAY_FILTER)
endif

ifeq ($(PRC_NO_WARN_SIZE), TRUE)
	RFLAGS += -noWarnSize
endif

ifeq ($(PRC_QUIET), TRUE)
	RFLAGS += -quiet
endif

ifeq ($(PRCMERGE_QUIET), TRUE)
	INTERNAL_PRCMERGE_FLAGS += -quiet
	PRCFLAGS += -quiet
endif

# Librarian settings
AR=m68k-palmos-ar
ARFLAGS= -rc

# function for converting sources to object file names in one of output directories
define SOURCE_LIST_TO_OBJS
	$(addprefix $(OBJ_DIR)/, $(addsuffix .o, $(foreach file, $(SOURCES), \
	$(basename $(notdir $(file))))))
endef

# function for converting sources to dependency file names in one of output directories
define SOURCE_LIST_TO_DEPS
	$(addprefix $(OBJ_DIR)/, $(addsuffix .d, $(foreach file, $(SOURCES), \
	$(basename $(notdir $(file))))))
endef

# function for converting resources into resource object files
define RESOURCE_LIST_TO_OBJS
	$(addprefix $(OBJ_DIR)/, $(addsuffix .trc, $(foreach file, $(RESOURCES), \
	$(basename $(file)))))
endef

# function for converting resources into resource dependency files
define RESOURCE_LIST_TO_DEPS
	$(addprefix $(OBJ_DIR)/, $(addsuffix .d, $(foreach file, $(RESOURCES), \
	$(basename $(file)))))
endef

SEGMENT_BASE = multiple_code_sections

ifeq ($(MULTIPLE_CODE_SECTIONS), TRUE)
MULTISEGMENT_LINKER_INPUT = $(SEGMENT_BASE).o $(SEGMENT_BASE).ld
MULTISEGMENT_BUILD_INPUT = Sections.def
else
MULTISEGMENT_LINKER_INPUT =
MULTISEGMENT_BUILD_INPUT =
endif

ifeq ($(PROJECT_TYPE), slib)
SLIB_DEF_OBJ := $(addprefix $(OBJ_DIR)/, $(addsuffix -dispatch.o, $(basename $(notdir $(SLIB_DEF_FILE)))))
SLIB_DEF_ASSEMBLY := $(addsuffix -dispatch.s, $(basename $(notdir $(SLIB_DEF_FILE))))
SLIB_BUILD_PRC_FILE := $(SLIB_DEF_FILE)
else
SLIB_DEF_OBJ :=
SLIB_DEF_ASSEMBLY :=
SLIB_BUILD_PRC_FILE :=
endif

OBJS = $(SOURCE_LIST_TO_OBJS)
SOURCE_PATHS += $(sort $(foreach file, $(SOURCES), $(dir $(file))))
RESOURCE_OBJS = $(RESOURCE_LIST_TO_OBJS)
RESOURCE_PATHS += $(sort $(foreach file, $(RESOURCES), $(dir $(file))))

DEPS = $(SOURCE_LIST_TO_DEPS) $(RESOURCE_LIST_TO_DEPS)

VPATH :=
VPATH += $(addprefix :, $(subst  ,:, $(filter-out $($(subst, :, ,$(VPATH))), $(SOURCE_PATHS) $(RESOURCE_PATHS))))

LOCAL_INCLUDES = $(foreach path, $(SOURCE_PATHS), $(addprefix -I, $(path)))
INCLUDES = $(LOCAL_INCLUDE_PATHS) $(LOCAL_INCLUDES) $(SYSTEM_INCLUDE_PATHS) $(PRE_INCLUDE_PATHS)
CPP_INCLUDES = -I"$(TOOLS_DIR)include/stlport"

# Now add additional settings specified by user
LDFLAGS += $(ADDITIONAL_LINK_LIBRARIES)
LDFLAGS += $(ADDITIONAL_LINKER_FLAGS)
LDFLAGS += $(foreach libpath, $(ADDITIONAL_LINK_LIBPATH), $(addprefix -L, $(libpath)))
CFLAGS += $(foreach define, $(DEFINES), $(addprefix -D, $(define)))
CFLAGS += $(foreach define, $(UNDEFINES), $(addprefix -U, $(define)))
CFLAGS += $(ADDITIONAL_COMPILER_FLAGS)
RFLAGS += $(ADDITIONAL_PRC_FLAGS)
PRCFLAGS += $(ADDITIONAL_PRCMERGE_FLAGS)


# Specify additional archival flags (for static libraries)
ARFLAGS += $(ADDITIONAL_AR_FLAGS)

ifeq ($(CREATOR_ID), )
	CREATOR_ID = STRT
endif

ifeq ($(DB_TYPE), )
	DB_TYPE = appl
endif

ifeq ($(DATABASE_VERSION), )
	DATABASE_VERSION = 1
endif

PRCFLAGS += -dbVersion $(DATABASE_VERSION) $(DATABASE_PROTECT) $(DATABASE_HIDDEN) $(DATABASE_BACKUP) $(DATABASE_RESET) $(DATABASE_BUNDLE)

ifeq ($(PROJECT_TYPE), )
	PROJECT_MAKE_TARGET = application
endif

ifeq ($(PROJECT_TYPE), appl)
	PROJECT_MAKE_TARGET = application
endif
ifeq ($(PROJECT_TYPE), slib)
	PROJECT_MAKE_TARGET = application
endif
ifeq ($(PROJECT_TYPE), lib)
	PROJECT_MAKE_TARGET = static_lib
endif

# without 'code #1' app
BUILDPRCFLG	= --no-check-resources

###############################################################################
# Dependency includes

-include $(DEPS)


###############################################################################
# Targets

#	Eclipse requires an all target to get the work done
all: $(PROJECT_MAKE_TARGET)

# Only invoke this make target if you want to build applications
# or shared libraries (not for static libraries)
application: $(OBJ_DIR) $(TARGET)

# Only invoke this make target if you want to build static libraries
# (not applications or shared libraries)
static_lib: $(OBJ_DIR) $(STATIC_LIB_TARGET)


# rule to create the object file directories if needed
$(OBJ_DIR):
	@[ -d $(OBJ_DIR) ] || mkdir $(OBJ_DIR) > /dev/null 2>&1


# main/68K C/C++ sources
$(OBJ_DIR)/%.o : %.c
	@echo
	$(CC) -c $< $(INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.cpp
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.cxx
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.cp
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.cc
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.C
	@echo
	$(CC) -c $< $(INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.CC
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.CPP
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(OBJ_DIR)/%.o : %.CXX
	@echo
	$(CC) -c $< $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(CC) -c $< $(DEPFLAGS) $(INCLUDES) $(CPP_INCLUDES) $(CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)

# XRD sources
$(OBJ_DIR)/%.trc : %.xrd
	@echo
	"$(TOOLS_DIR)PalmRC" -p $(TARGET_FORMAT) $(RFLAGS) -locale $(LOCALE) $< -o $@
	echo -n $(@:%.trc=%.d) $@ : ' ' > $(@:%.trc=%.d) && \
	"$(TOOLS_DIR)PalmRC" -quiet -p $(TARGET_FORMAT) -makedeps $(@:%.trc=%.d).tmp $(RFLAGS) -locale $(LOCALE) $< && \
	/usr/bin/cygpath -m -f $(@:%.trc=%.d).tmp | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.trc=%.d) && \
	rm -rf $(@:%.trc=%.d).tmp && \
	echo -e \\n\\n$(@:%.trc=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.trc=%.d)
	
$(OBJ_DIR)/%.trc : %.XRD
	@echo
	"$(TOOLS_DIR)PalmRC" -p $(TARGET_FORMAT) $(RFLAGS) -locale $(LOCALE) $< -o $@
	echo -n $(@:%.trc=%.d) $@ : ' ' > $(@:%.trc=%.d) && \
	"$(TOOLS_DIR)PalmRC" -quiet -p $(TARGET_FORMAT) -makedeps $(@:%.trc=%.d).tmp $(RFLAGS) -locale $(LOCALE) $< && \
	/usr/bin/cygpath -m -f $(@:%.trc=%.d).tmp | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.trc=%.d) && \
	rm -rf $(@:%.trc=%.d).tmp && \
	echo -e \\n\\n$(@:%.trc=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.trc=%.d)


# multi-section rules
$(SEGMENT_BASE).o : $(SEGMENT_BASE).s

$(SEGMENT_BASE).s $(SEGMENT_BASE).ld : Sections.def makefile makefile-engine.mk
	@echo
	$(MS) -b $(SEGMENT_BASE) Sections.def

# shared library rules
$(SLIB_DEF_ASSEMBLY) : $(SLIB_DEF_FILE) makefile makefile-engine.mk
	@echo
	$(SG) $<
	
$(SLIB_DEF_OBJ) : $(SLIB_DEF_ASSEMBLY)
	@echo
	$(AS) -o $@ $<

$(LINKER_OUTPUT) : $(OBJS) $(MULTISEGMENT_LINKER_INPUT) $(SLIB_DEF_OBJ)
	@echo
	@echo "...Linking..."
	$(LD) -o $(LINKER_OUTPUT) $(OBJS) $(MULTISEGMENT_LINKER_INPUT) $(SLIB_DEF_OBJ) $(LDFLAGS)

#$(TARGET): $(LINKER_OUTPUT) $(RESOURCE_OBJS)
#	@echo
#	@echo "...Creating PRC: $(TARGET)..."
#	build-prc $(SLIB_BUILD_PRC_FILE) -o $(OBJ_DIR)/buildprc_temp.prc -c '$(CREATOR_ID)' -n $(DATABASE_NAME) $(MULTISEGMENT_BUILD_INPUT) $(LINKER_OUTPUT)
#	@echo
#	"$(TOOLS_DIR)PRCMerge" $(INTERNAL_PRCMERGE_FLAGS) -omit pref $(OBJ_DIR)/buildprc_temp.prc -o $(OBJ_DIR)/prcmerge_temp.prc
#	@echo
#	"$(TOOLS_DIR)PRCMerge" -dbType '$(DB_TYPE)' -dbCreator '$(CREATOR_ID)' -n $(DATABASE_NAME) $(PRCFLAGS) -o $(TARGET) \
#	$(RESOURCE_OBJS) $(OBJ_DIR)/prcmerge_temp.prc
#	@rm -rf $(OBJ_DIR)/buildprc_temp.prc $(OBJ_DIR)/prcmerge_temp.prc
#	@echo ...done...
$(TARGET): $(CODE_RSC) $(RESOURCE_OBJS)
	@echo
	@echo "...Creating PRC: $(TARGET)..."
	build-prc $(BUILDPRCFLG) $(SLIB_BUILD_PRC_FILE) -o $(OBJ_DIR)/buildprc_temp.prc -c '$(CREATOR_ID)' -n $(DATABASE_NAME) $(MULTISEGMENT_BUILD_INPUT) $(CODE_RSC)
	@echo
	"$(TOOLS_DIR)PRCMerge" $(INTERNAL_PRCMERGE_FLAGS) -omit pref $(OBJ_DIR)/buildprc_temp.prc -o $(OBJ_DIR)/prcmerge_temp.prc
	@echo
	"$(TOOLS_DIR)PRCMerge" -dbType '$(DB_TYPE)' -dbCreator '$(CREATOR_ID)' -n $(DATABASE_NAME) $(PRCFLAGS) -o $(TARGET) \
	$(RESOURCE_OBJS) $(OBJ_DIR)/prcmerge_temp.prc
	@rm -rf $(OBJ_DIR)/buildprc_temp.prc $(OBJ_DIR)/prcmerge_temp.prc
	@echo ...done...

$(OBJ_DIR)/code03e8.grc: $(OBJ_DIR)/$(ARTIFACT_NAME)
	$(OR) $(OBJ_DIR)/$(ARTIFACT_NAME)
	mv code0001.$(ARTIFACT_NAME).grc $@
	rm *.$(ARTIFACT_NAME).grc

$(OBJ_DIR)/*.$(ARTIFACT_NAME).grc:  $(OBJ_DIR)/$(ARTIFACT_NAME)
	$(OR) $(OBJ_DIR)/$(ARTIFACT_NAME)
	mv *.$(ARTIFACT_NAME).grc $(OBJ_DIR)/
	
$(STATIC_LIB_TARGET) : $(OBJS)
	@echo
	@echo "...Linking Static Library: $(STATIC_LIB_TARGET)..."
	$(AR) $(ARFLAGS) $(STATIC_LIB_TARGET) $(OBJS) 


FORCE:

# Eclipse requires a clean command
# just delete everything in OBJ_DIR and any section files
clean :: FORCE
	-rm -rf $(OBJ_DIR)/* *-sections.* *-dispatch.s

